---
title: SadTalker API Usage Guide
slug: v-jLmWFv0B5P3yrLwoFoA
createdAt: Thu Jul 18 2024 06:07:52 GMT+0000 (Coordinated Universal Time)
updatedAt: Thu Jul 18 2024 13:42:11 GMT+0000 (Coordinated Universal Time)
---

# SadTalker API Usage Guide

## Introduction

This document will guide developers on how to use the aonweb library to call the SadTalker API, which is used to generate AI-driven talking avatars.

## Prerequisites

- Node.js environment
- `aonweb` library installed
- Valid Aonet APPID

## Basic Usage

### 1. Import Required Modules

```js
import { AI, AIOptions } from 'aonweb';
```

### 2. Initialize AI Instance

```js
const ai_options = new AIOptions({
    appId: 'your_app_id_here',
    dev_mode: true
});

const aonweb = new AI(ai_options);
```

### 3. Prepare Input Data Example

```js
const data = {
   input:{
    "still": true,
    "enhancer": "gfpgan",
    "preprocess": "full",
    "driven_audio": "https://aonweb.ai/pbxt/Jf1gczNATWiC94VPrsTTLuXI0ZmtuZ6k0aWBcQpr7VuRc5f3/japanese.wav",
    "source_image": "https://replicate.delivery/pbxt/Jf1gcsODejVsGRd42eeUj0RXX11zjxzHuLuqXmVFwMAi2tZq/art_1.png"
    }
};
```

### 4. Call the AI Model

```js
const price = 8; // Cost of the AI call
try {
    const response = await aonweb.prediction("/predictions/ai/sadtalker@lucataco", data, price);
    // Handle response
     console.log("sadtalker result:", response);
} catch (error) {
    // Error handling
    console.error("Error generating :", error);
}
```


### Parameter Description

- `still`: Boolean, set to true to generate a static image instead of a video.
- `enhancer`: String, specifies the image enhancer to use, here using "gfpgan".
- `preprocess`: String, specifies the preprocessing method, here using "full".
- `driven_audio`: String, the URL of the audio file to drive the animation.
- `source_image`: String, the URL of the source image, which is the avatar to be animated.

### Notes

- Ensure that the provided image and audio URLs are publicly accessible.
- The API may take some time to process the input and generate the result, consider implementing appropriate wait or retry logic.
- Handle possible errors, such as network issues, invalid input, or API limitations.

### Example Response

The API response will contain the URL of the generated talking avatar or other relevant information. Parse and use the response data according to the actual API documentation.
